"use strict";

/* SOME CONSTANTS */
let endpoint01 = "https://m6gwewmkf5.execute-api.us-east-1.amazonaws.com/default/project3shaferSOLVED";

/* SUPPORTING FUNCTIONS */

let loginController = () => {
    // Clear any previous messages
    $('#login_message').html("");
    $('#login_message').removeClass();

    // Client-side error trapping
    let username = $("#username").val();
    let password = $("#password").val();
    if (username == "" || password == "") {
        $('#login_message').html('The user name and password are both required.');
        $('#login_message').addClass("alert alert-danger text-center");
        return;
    }

    let the_serialized_data = $("#form-login").serialize();
    console.log(the_serialized_data);

    $.ajax({
        "url": endpoint01 + "/login",
        "method": "POST",
        "data": the_serialized_data,
        "success": (results) => {
            console.log(results);
            if (!results || Object.keys(results).length === 0) {
                $('#login_message').html("Login Failed. Try again.");
                $('#login_message').addClass("alert alert-danger text-center");
            } else {
                // Save token for future requests
                localStorage.setItem("token", results[0].lasttoken);
				console.log(localStorage.token)
                // Hide all content wrappers and show welcome
                $(".content-wrapper").hide();
                $("#div-welcome").show();
                // Unlock secured content
                $(".secured").removeClass("locked");		
                $(".secured").addClass("unlocked");
            }
        },
        "error": (data) => {
            console.log(data);
            $('#login_message').html("Login Failed. Try again.");
            $('#login_message').addClass("alert alert-danger text-center");
        }
    });

    $("html, body").animate({ scrollTop: "0px" });
};


//document ready section
$(document).ready( () => {

	$("html, body").animate({ scrollTop: "0px" });

    /* ----------------- start up navigation -----------------*/	
    /* controls what gets revealed when the page is ready     */

    /* this reveals the default page */

    $(".secured").removeClass("unlocked");
    $(".secured").addClass("locked");
    
	if (localStorage.token){
		$(".secured").removeClass("locked");		
		$(".secured").addClass("unlocked");
        $("#div-welcome").show();
	} else {
        $("#div-login").show();
    }

    /* ------------------  basic navigation -----------------*/	
    /* this controls navigation - show / hide pages as needed */

	/* links on the menu */
	/* what happens if any of the navigation links are clicked? */
	$('.nav-link').click( () => {
		$("html, body").animate({ scrollTop: "0px" }); /* scroll to top of page */
		$(".navbar-collapse").collapse('hide'); /* explicitly collapse the navigation menu */
	});
		
	/* what happens if the link-AAA anchor tag is clicked? */
	$('#link-AAA').click( () => {
		$(".content-wrapper").hide(); 	/* hide all content-wrappers */
		$("#div-AAA").show(); /* show the chosen content wrapper */
	});
		
	/* what happens if the link-BBB anchor tag is clicked? */
	$('#link-BBB').click( () => {
		$(".content-wrapper").hide(); 	
		$("#div-BBB").show(); 
	});

	/* what happens if the link-CCC anchor tag is clicked? */
	$('#link-CCC').click( () => {
		$(".content-wrapper").hide(); 	
		$("#div-CCC").show(); 
	});

	/* what happens if the link-CCC anchor tag is clicked? */
	$('#link-home').click( () => {
		$(".content-wrapper").hide(); 	
		$("#div-welcome").show(); 
	});

	/* what happens if the login button is clicked? */
	$('#btnLogin').click( () => {
		loginController();
	});

	/* what happens if the quit button or logout link is clicked? */
    $('#btnQuit,#link-logout').click(() => {
        $(".content-wrapper").hide(); 	
        localStorage.removeItem("token");
        window.location = "./index.html";
    });

}); /* end the document ready event*/