"use strict";
//globals
const endpoint_url = "https://misdemo.temple.edu/todo/addtask";
const endpoint_url2 = "https://misdemo.temple.edu/todo/tasks";

// supporting functions

let putTheDataIn = () => {
	// get the data off the form
	let the_serialized_data = $("#frmMyStuff").serialize();
	console.log(the_serialized_data);
	
	//now send it to the API
	$.ajax({
		url: endpoint_url,
		data: the_serialized_data,
		method: "POST",
		success: (result) => {
			console.log(result);
		},
		error: (data) => {
			console.log(data);
		}
	});
}

let getTheDataOut = () => {
	// get the data off the form
	let the_serialized_data = $("#frmMyStuff").serialize();
	console.log(the_serialized_data);
	
	//now get it back out again
	$.ajax({
		url: endpoint_url2,
		data: the_serialized_data,
		method: "GET",
		success: (result) => {
			console.log(result);
			$("#ulOutput").html(""); //empty the ul tag
			for (let i = 0; i < result.length; i++){
				$("#ulOutput").append("<li>" + result[i]["task"] + "</li>");
			}
		},
		error: (data) => {
			console.log(data);
		}
	});
}

let twoStepOperation = async () => {
	// get the data off the form
	let the_serialized_data = $("#frmMyStuff").serialize();
	console.log(the_serialized_data);
	
	//now send it to the API
	await $.ajax({
		url: endpoint_url,
		data: the_serialized_data,
		method: "POST",
		success: (result) => {
			console.log(result);
		},
		error: (data) => {
			console.log(data);
		}
	});
	
	//now get it back out again
	await $.ajax({
		url: endpoint_url2,
		data: the_serialized_data,
		method: "GET",
		success: (result) => {
			console.log(result);
			$("#ulOutput").html(""); //empty the ul tag
			for (let i = 0; i < result.length; i++){
				$("#ulOutput").append("<li>" + result[i]["task"] + "</li>");
			}
		},
		error: (data) => {
			console.log(data);
		}
	});
	
}



//event handlers
$(document).ready(()=>{
	
	$("#idTheTask").focus();
	
	$("#btnOne").click( ()=>{
		putTheDataIn();
		//getTheDataOut();
		//twoStepOperation();
	} );
	
});