// MIS3502 - Web Service Template
// Created by: Jeremy Shafer
// Fall 2024

// REMINDER - Don't forget to change your database connection
// timeout from 3 seconds to 3 minutes.
// Look under Configuration / General Configuration

// declarations (not all are needed) *****************************************
import qs from 'qs'; //for parsing URL encoded data
import axios from 'axios'; // for calling another API
import mysql from 'mysql2/promise';  //for talking to a database
import { SESClient, SendEmailCommand } from "@aws-sdk/client-ses";


const dboptions = {
  'user' : '',
  'password' : '',
  'database' : '',
  'host' : 'dataanalytics.temple.edu'
};

//global connection variable
var connection;

const features = [
	"Issue a GET against datetime.  The response will be the current date and time in Philadelphia in JSON.",
	"Issue a GET against myname.  The response will be my name in JSON.",
	"Created by Jeremy Shafer",	
	"Last modified by NoName McHiggens",	
	];


// supporting functions ******* STUDENT MAY EDIT ***********

let theDatetimeFunction = async (res,query) => {
	//work and return the result
	let [result] = await connection.execute("select DATE_FORMAT(NOW(), '%m-%d-%Y %h:%i %p') AS the_date_and_time");
	return formatres(res,result[0]['the_date_and_time'],200);
}

let myName = (res,query) => {
	//work and return the result
	return formatres(res,"NoName McHiggens",200);
}

// do not delete this handy little supporting function
let formatres = async (res, output, statusCode) => {
	
	// kill the global database connection
	if (connection != undefined &&  
		typeof(connection)=='object' &&  
		typeof(connection.end())=='object'  ){
		await connection.end();
	}

	res.statusCode = statusCode;
	res.body = JSON.stringify(output);
	return res;	
}

// do not delete this handy little supportng function
function isEmpty(obj) {
    return Object.keys(obj).length === 0;
}

// My Routing Function ****** STUDENT MAY EDIT **********

let myRoutingFunction = (res,method,path,query,body) => {

	// conditional statements go here.
	// look at the path and method and return the output from the 
	// correct supporting function.

	// Simple GET request with no features specified results
	// in a list of features / instructions
	if (method == "GET" && path == ""){
		return formatres(res, features, 200);
	}

	if (method == "GET" && path == "datetime"){
		return theDatetimeFunction(res,query);
	}

	if (method == "GET" && path == "myname"){
		return myName(res,query);
	}

	return(res);
}


// event handler **** DO NOT EDIT ***********

// Students should not have to change the code here.
// Students should be able to read and understand the code here.

export const handler = async (request) => {

	connection = await mysql.createConnection(dboptions);	

	// identify the method (it will be a string)
	let method = request["httpMethod"];
	
	// identify the path (it will also be a string)
	let fullpath = request["path"];
	
	// we clean the full path up a little bit
	if (fullpath == undefined || fullpath == null){ fullpath = ""};
	let pathitems = fullpath.split("/");
	let path = pathitems[2];
	if (path == undefined || path == null){ path = ""};
	
	// identify the querystring ( we will convert it to 
	//   a JSON object named query)
	let query = request["queryStringParameters"];
	if (query == undefined || query == null){ query={} };
	
	// identify the body (we will convert it to 
	//   a JSON object named body)
	let body = qs.parse(request["body"]);
	if (body == undefined || body == null){ body={} };

	// Create the default response object that will include 
	// the status code, the headers needed by CORS, and
	// the string to be returned formatted as a JSON data structure.
    let res = {
        'statusCode': 400,
        'headers': {
            'Access-Control-Allow-Origin': '*',
            'Access-Control-Allow-Credentials': true  
        },
        'body': JSON.stringify("Feature not found."),
    };

	// run all the parameters through my routing function
	// and return the result
    return myRoutingFunction(res,method,path,query,body);
    
    //*** this is a good place to test one supporting function at a time
    //query={};
    //return theDatetimeFunction(res,query);
    
};