
-- SQL script to set up the sample data for the Introduction to SQL exercise

-- Drop tables if they already exist (optional)
DROP TABLE IF EXISTS engagements;
DROP TABLE IF EXISTS employees;
DROP TABLE IF EXISTS customers;

-- Create employees table
CREATE TABLE employees (
    id INT PRIMARY KEY auto_increment,
    first_name VARCHAR(50),
    last_name VARCHAR(50),
    role VARCHAR(50),
    hire_date DATE
);

-- Create customers table
CREATE TABLE customers (
    id INT PRIMARY KEY auto_increment,
    companyname VARCHAR(100),
    industry VARCHAR(50)
);

-- Create engagements table
CREATE TABLE engagements (
    id INT PRIMARY KEY auto_increment,
    employee_id INT,
    customer_id INT,
    hours_billed INT,
    status VARCHAR(20),
    projectname VARCHAR(100)
);

-- Insert employees (10 employees total)
INSERT INTO employees ( first_name, last_name, role, hire_date) VALUES
    (  'Alice',    'Smith',    'Consultant',       '2022-01-10'),
    (  'Bob',      'Johnson',  'Project Manager',  '2021-05-15'),
    (  'Carol',    'Lee',      'Analyst',          '2023-03-01'),
    (  'David',    'Chen',     'Consultant',       '2020-11-20'),
    (  'Elena',    'Garcia',   'Consultant',       '2022-07-05'),
    (  'Frank',    'Miller',   'Developer',        '2023-02-14'),
    (  'Grace',    'Kim',      'Consultant',       '2019-09-30'),
    (  'Henry',    'Nguyen',   'Analyst',          '2020-05-20'),
    (  'Isabella', 'Davis',    'Project Manager',  '2022-11-11'),
    ( 'Jack',     'Wilson',   'Consultant',       '2021-01-01');

-- Insert customers (20 customers total)
INSERT INTO customers (companyname, industry) VALUES
    ('Juniper Financial', 'Finance'),
    ('Arcane Corp',         'Technology'),
    ('BrightCo',          'Healthcare'),
    ('Cedar Solutions',   'Finance'),
    ('Gemstone Inc',      'Education'),
    ('Horizon Health',    'Healthcare'),
    ('Quartz Design',     'Design'),
    ('Redfern Media',     'Media'),
    ('IvyTech',           'Technology'),
    ('Keystone Labs',     'Biotech'),
    ('Luna Logistics',    'Transportation'),
    ('DynaSoft',          'Technology'),
    ('Elm Tree LLC',      'Manufacturing'),
    ('Fox Industries',    'Retail'),
    ('Maple Marketing',   'Advertising'),
    ('Nova Networks',     'Telecommunications'),
    ('Oakridge Energy',   'Energy'),
    ('Pine Solutions',    'Consulting'),
    ('Summit Sports',     'Sporting Goods'),
    ('Terra Agriculture', 'Agriculture');

-- Insert engagements (33 records total)
INSERT INTO engagements (employee_id, customer_id, hours_billed, status, projectname) VALUES
    (  1, 1, 40, 'Completed', 'Hardware Inventory'),
    (  1, 2, 20, 'Active', 'IT Security Assessment'),
    (  2, 1, 30, 'Completed', 'Network Upgrade Plan'),
    (  3, 3, 25, 'Active', 'Cloud Migration'),
    (  2, 4, 15, 'Active', 'Help Desk Optimization'),
    (  4, 2, 35, 'Completed', 'Disaster Recovery Drill'),
    (  3, 1, 10, 'Completed', 'Data Backup and Retention'),
    (  4, 3, 20, 'Active', 'Endpoint Compliance Audit'),
    ( 5, 1, 8,  'Completed', 'Trillium Alpha'),
    ( 2, 5, 18, 'Active', 'Orion Gate'),
    ( 5, 2, 7,  'Completed', 'Project Aegis'),
    ( 6, 6, 22, 'Completed', 'Nova Sentinel'),
    ( 7, 7, 30, 'Active', 'Quantum Harbor'),
    ( 7, 9, 20, 'Completed', 'Obsidian Dawn'),
    ( 8,11, 25, 'Completed', 'Valkyrie Node'),
    ( 9,12, 12, 'Active', 'Azure Lantern'),
    ( 9,13, 28, 'Completed', 'Titan Forge'),
    (10,14, 17, 'Completed', 'Spectra Horizon'),
    (10,15, 22, 'Active', 'Hyperion Flow'),
    ( 1,16, 15, 'Active', 'Crimson Lock'),
    ( 2,17, 30, 'Completed', 'Atlas Cloud Migration'),
    ( 3,18, 10, 'Active', 'Horizon Security Framework'),
    ( 4,19, 40, 'Completed', 'Sentinel Backup Initiative'),
    ( 5,20, 8,  'Active', 'Nova Data Warehouse'),
    ( 6,17, 16, 'Active', 'Obsidian Endpoint Shield'),
    ( 7,14, 21, 'Completed', 'Phoenix Disaster Recovery'),
    ( 8, 6, 13, 'Active', 'Echo Identity Project'),
    ( 9, 2, 11, 'Completed', 'Celestial Bridge'),
    (10, 3, 26, 'Active', 'Ironclad Horizon');
